#ifndef CRFEPURENGINEERINGDIALOG_H
#define CRFEPURENGINEERINGDIALOG_H

#include <QDialog>
#include <ui_CRfePurEngineeringDialog.h>
#include "../ui/ConfigDialog.h"

#include <QrfeTraceModule>

class QrfeReaderInterface;
class QrfeRfePurReader;

class ReaderTabWidget;

class CRfePurEngineeringDialog : public QDialog, QrfeTraceModule, ConfigDialog
{
    Q_OBJECT

public:
    CRfePurEngineeringDialog(QWidget *parent = 0);
    ~CRfePurEngineeringDialog();

public slots:
	int exec(QrfeReaderInterface* reader);
	virtual void done(int r);

private slots:
	void tabWidgetWorking();
	void tabWidgetIdle();

	void currentTabChanged ( int index );

	void permissionsChanged();

protected:
	virtual void closeEvent ( QCloseEvent * event );

private:
	void addTabWidget(ReaderTabWidget* w);
	void reloadExecutionCount(int tabIndex);

private:
    Ui::CRfePurEngineeringDialogClass ui;

    QrfeRfePurReader* 		m_reader;

	ushort 					m_originalAttenuation;
	uchar 					m_originalFrequencyMode;
	QList<uint>				m_originalFrequency;
	uchar 					m_originalAntenna;
	bool 					m_originalCyclicModus;

	bool 					m_normalEnginerring;
	bool 					m_labFunctions;
	bool 					m_hiddenSettings;
    bool 					m_interfaceSettings;
    bool 					m_reflectedPowerSettings;
    bool 					m_advancedSettings;

	QList<ReaderTabWidget*>	m_tabWidgets;
};

#endif // CRFEPURENGINEERINGDIALOG_H
